#include "scripts.h"
#include "engine.h"
#ifndef WIN32
#include <wchar.h>
#endif
int Exe = 6;
typedef char DefinitionClass;
#ifdef WIN32
struct GameObjListNode {
	GameObjListNode *next;
	GameObject *obj;
};
struct GameObjList {
	unsigned int *vtable;
	GameObjListNode *head;
	GameObjListNode *tail;
};
#else
#ifdef RH8
struct GameObjListNode {
	GameObjListNode *next;
	GameObject *obj;
};
struct GameObjList {
	unsigned int *vtable;
	GameObjListNode *head;
	GameObjListNode *tail;
};
#else
struct GameObjListNode {
	int unknown;
	GameObjListNode *next;
	GameObject *obj;
};
struct GameObjList {
	GameObjListNode *head;
	GameObjListNode *tail;
	unsigned int *vtable;
};
#endif
#endif

typedef GameObject *(*ago) (GameObject *obj);
typedef const char *(*Get_Name) (char *ro);
typedef int (*Get_ClassID) (DefinitionClass *def);

typedef unsigned char *(*Find_Player) (int);
Find_Player FindPlayer;
typedef DefinitionClass *(*Find_Named_Def) (const char *name, bool unk);
Find_Named_Def FindNamedDef;
#ifdef WIN32
typedef void (*ReInit) (DefinitionClass *def);
#else
typedef void (*ReInit) (GameObject *obj,DefinitionClass *def);
#endif
ReInit SoldierReInit;
#ifdef WIN32
typedef void (*PostReInit) (void);
#else
typedef void (*PostReInit) (GameObject *obj);
#endif
PostReInit Post_ReInit;
#ifdef WIN32
typedef void (*SetMax) (float max);
#else
typedef void (*SetMax) (unsigned int *def,float max);
#endif
SetMax SetMaxHealth;
SetMax SetMaxShieldStrength;
typedef void (*GrantSupplies) (GameObject *obj);
GrantSupplies Grant_Supplies;
#ifdef WIN32
typedef void (*PowerupGrant) (GameObject *obj,int powerup,bool unk);
#else
typedef void (*PowerupGrant) (DefinitionClass *def,GameObject *obj,int powerup,bool unk);
#endif
PowerupGrant Powerup_Grant;
typedef const char *(*GetArmorName) (unsigned int ID);
GetArmorName Get_Armor_Name;
typedef unsigned int(*GetArmorType) (const char *name);
GetArmorType Get_Armor_Type;
#ifdef WIN32
typedef void (*MarkOwnerDirty) (void);
#else
typedef void (*MarkOwnerDirty) (char *def);
#endif
MarkOwnerDirty Mark_Owner_Dirty;
#ifdef WIN32
typedef bool (*IsAvailable) (void);
#else
typedef bool (*IsAvailable) (GameObject *obj);
#endif
IsAvailable Is_Available_For_Purchase;
#ifdef WIN32
typedef bool (*RequestVehicle) (int Preset,float Delay,GameObject *Owner);
#else
typedef bool (*RequestVehicle) (GameObject *obj,int Preset,float Delay,GameObject *Owner);
#endif
RequestVehicle Request_Vehicle;
#ifdef WIN32
typedef void (*ToggleFlyMode) (void);
#else
typedef void (*ToggleFlyMode) (GameObject *obj);
#endif
ToggleFlyMode ToggleFly;
typedef void (*ConsoleInput)(const char *);
ConsoleInput Parse_Console_Input;
typedef void (*ConsoleOut) (const char *);
ConsoleOut Output_To_Console;
typedef void (*spt) (unsigned char *playerdata, int type);
spt SetPlayerType;
typedef int (*gpc) (void);
gpc GetPlayerCount;
GameObjList *BuildingGameObjList;
GameObjList *SmartGameObjList;
GameObjList *BaseGameObjList;
_Set_Background_Music_Player Set_Background_Music_Player;
_Fade_Background_Music_Player Fade_Background_Music_Player;
_Stop_Background_Music_Player Stop_Background_Music_Player;
_Enable_Radar_Player Enable_Radar_Player;
_Display_GDI_Player_Terminal_Player Display_GDI_Player_Terminal_Player;
_Display_NOD_Player_Terminal_Player Display_NOD_Player_Terminal_Player;
_Set_Screen_Fade_Color_Player Set_Screen_Fade_Color_Player;
_Set_Screen_Fade_Opacity_Player Set_Screen_Fade_Opacity_Player;
void InitEngine()
{
	if (Exe == 0) //game.exe
	{
		BuildingGameObjList = (GameObjList *)0x00856FE8;
		SmartGameObjList = (GameObjList *)0x00856FD8;
		BaseGameObjList = (GameObjList *)0x00856FF8;
		FindPlayer = (Find_Player)0x004157E0;
		FindNamedDef = (Find_Named_Def)0x00526860;
		SoldierReInit = (ReInit)0x006C7410;
		Post_ReInit = (PostReInit)0x006B65F0;
		SetMaxHealth = (SetMax)0x00691820;
		SetMaxShieldStrength = (SetMax)0x006930E0;
		Grant_Supplies = (GrantSupplies)0x00470AC0;
		Powerup_Grant = (PowerupGrant)0x006F09F0;
		Get_Armor_Name = (GetArmorName)0x006877D0;
		Get_Armor_Type = (GetArmorType)0x00687750;
		Mark_Owner_Dirty = (MarkOwnerDirty)0x00693740;
		Is_Available_For_Purchase = (IsAvailable)0x006EE010;
		Request_Vehicle = (RequestVehicle)0x006EE1A0;
		ToggleFly = (ToggleFlyMode)0x006CFC80;
		Parse_Console_Input = (ConsoleInput)0x004287E0;
		Output_To_Console = (ConsoleOut)0x00428B50;
		SetPlayerType = (spt)0x0040D600;
		GetPlayerCount = (gpc)0x00417040;
	}
	if (Exe == 1) //server.dat
	{
		BuildingGameObjList = (GameObjList *)0x008561D0;
		SmartGameObjList = (GameObjList *)0x008561C0;
		BaseGameObjList = (GameObjList *)0x008561E0;
		FindPlayer = (Find_Player)0x004157E0;
		FindNamedDef = (Find_Named_Def)0x00526100;
		SoldierReInit = (ReInit)0x006C6CB0;
		Post_ReInit = (PostReInit)0x006B5E90;
		SetMaxHealth = (SetMax)0x006910C0;
		SetMaxShieldStrength = (SetMax)0x00692980;
		Grant_Supplies = (GrantSupplies)0x00470230;
		Powerup_Grant = (PowerupGrant)0x006EFFB0;
		Get_Armor_Name = (GetArmorName)0x00687700;
		Get_Armor_Type = (GetArmorType)0x00686FF0;
		Mark_Owner_Dirty = (MarkOwnerDirty)0x00692FE0;
		Is_Available_For_Purchase = (IsAvailable)0x006ED5D0;
		Request_Vehicle = (RequestVehicle)0x006ED760;
		ToggleFly = (ToggleFlyMode)0x006CF520;
		Parse_Console_Input = (ConsoleInput)0x00428960;
		Output_To_Console = (ConsoleOut)0x00428CD0;
		SetPlayerType = (spt)0x0040D600;
		GetPlayerCount = (gpc)0x00417040;
	}
	if (Exe == 2) //RH73
	{
		BuildingGameObjList = (GameObjList *)0x08BA05FC;
		SmartGameObjList = (GameObjList *)0x08BA05D8;
		BaseGameObjList = (GameObjList *)0x08BA05D8;
		FindPlayer = (Find_Player)0x080A9CDC;
		FindNamedDef = (Find_Named_Def)0x0836557C;
		SoldierReInit = (ReInit)0x0815C23C;
		Post_ReInit = (PostReInit)0x081528EC;
		SetMaxHealth = (SetMax)0x08111B88;
		SetMaxShieldStrength = (SetMax)0x08111C9C;
		Grant_Supplies = (GrantSupplies)0x080C472C;
		Powerup_Grant = (PowerupGrant)0x08144268;
		Get_Armor_Name = (GetArmorName)0x0810F87C;
		Get_Armor_Type = (GetArmorType)0x0810F7B4;
		Mark_Owner_Dirty = (MarkOwnerDirty)0x08111D84;
		Is_Available_For_Purchase = (IsAvailable)0x0818C8C4;
		Request_Vehicle = (RequestVehicle)0x0818CAF0;
		ToggleFly = (ToggleFlyMode)0x08168740;
		Parse_Console_Input = (ConsoleInput)0x0805BBB8;
		Output_To_Console = (ConsoleOut)0x0805BF40;
		SetPlayerType = (spt)0x080A7438;
		GetPlayerCount = (gpc)0x080AA7F0;
	}
	if (Exe == 3) //RH8
	{
		BuildingGameObjList = (GameObjList *)0x089A9090;
		SmartGameObjList = (GameObjList *)0x089A9078;
		BaseGameObjList = (GameObjList *)0x089A906C;
		FindPlayer = (Find_Player)0x080A510A;
		FindNamedDef = (Find_Named_Def)0x0831890A;
		SoldierReInit = (ReInit)0x0814A676;
		Post_ReInit = (PostReInit)0x08140AB8;
		SetMaxHealth = (SetMax)0x08103C18;
		SetMaxShieldStrength = (SetMax)0x08103D2E;
		Grant_Supplies = (GrantSupplies)0x080BC8D8;
		Powerup_Grant = (PowerupGrant)0x081332C6;
		Get_Armor_Name = (GetArmorName)0x08101AB8;
		Get_Armor_Type = (GetArmorType)0x081019FC;
		Mark_Owner_Dirty = (MarkOwnerDirty)0x08103E20;
		Is_Available_For_Purchase = (IsAvailable)0x008175F7A;
		Request_Vehicle = (RequestVehicle)0x08176184;
		ToggleFly = (ToggleFlyMode)0x08155762;
		Parse_Console_Input = (ConsoleInput)0x08063F56;
		Output_To_Console = (ConsoleOut)0x080642B2;
		SetPlayerType = (spt)0x080A2E50;
		GetPlayerCount = (gpc)0x080A5A62;
	}
	if (Exe == 4) //leveledit
	{
		BuildingGameObjList = (GameObjList *)0;
		SmartGameObjList = (GameObjList *)0;
		BaseGameObjList = (GameObjList *)0;
		FindPlayer = (Find_Player)0;
		FindNamedDef = (Find_Named_Def)0;
		SoldierReInit = (ReInit)0;
		Post_ReInit = (PostReInit)0;
		SetMaxHealth = (SetMax)0;
		SetMaxShieldStrength = (SetMax)0;
		Grant_Supplies = (GrantSupplies)0;
		Powerup_Grant = (PowerupGrant)0;
		Get_Armor_Name = (GetArmorName)0;
		Get_Armor_Type = (GetArmorType)0;
		Mark_Owner_Dirty = (MarkOwnerDirty)0;
		Is_Available_For_Purchase = (IsAvailable)0;
		Request_Vehicle = (RequestVehicle)0;
		ToggleFly = (ToggleFlyMode)0;
		Parse_Console_Input = (ConsoleInput)0;
		Output_To_Console = (ConsoleOut)0;
		SetPlayerType = (spt)0;
		GetPlayerCount = (gpc)0;
	}
}

GameObject *As_PhysicalGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x24]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x28;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x2C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_CinematicGameObj(GameObject *obj)
{
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x98]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xC0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0xA0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_VehicleGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x28]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x2C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x30;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_SmartGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x2C]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x30;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x34;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_DamageableGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x3C]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x4C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x44;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_SoldierGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x44]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x54;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x4C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_ScriptZoneGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x48]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x58;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x50;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_BuildingGameObj(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx, obj
		mov ebx, [ecx]
		mov eax, [ebx+0x40]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x50;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x48;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
const char *Get_Model(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return "DUMMY";
	}
#ifdef WIN32
	_asm{
		mov eax, o
		mov ebx, [eax+0x774]
		mov ecx, [ebx+0x3C]
		mov eax, [ecx]
		mov ebx, [eax+0x10]
		call ebx
	}
#else
	o+=0x774;
	char *p = (char *)*(unsigned int *)o;
	p+=0x54;
	char *r = (char *)*(unsigned int *)p;
#ifndef RH8
	r += 0x1C;
#endif
	char *v = (char *)*(unsigned int *)r;
#ifndef RH8
	r -= 0x1C;
	v += 4;
#endif
	v += 0x14;
	Get_Name *n = (Get_Name*)v;
	Get_Name gn = (Get_Name)*n;
	return gn(r);
#endif
}
int Get_Object_Type(GameObject *obj)
{
	GameObject *o = As_DamageableGameObj(obj);
	if (o == 0)
	{
		return 0;
	}
	char *c = (char *)obj;
	c += 0x764;
	return *(int *)c;
}
DefinitionClass *Get_Definition(GameObject *obj)
{
	char *c = (char *)obj;
	c += 0x6BC;
	return (DefinitionClass *)*(DefinitionClass **)c;
}
DefinitionClass *Get_Phys_Definition(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return 0;
	}
	o+=0x774;
	char *p = (char *)*(unsigned int *)o;
#ifdef WIN32
	p += 0x50;
#else
	p += 0x68;
#endif
	return (DefinitionClass *)*(unsigned int *)p;
}
int Get_Class_ID(DefinitionClass *def)
{
#ifdef WIN32
	_asm{
		mov ecx, def
		mov eax, [ecx]
		mov ebx, [eax+0x20]
		call ebx
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)def;
	c += 0x24;
	Get_ClassID *gcid = (Get_ClassID *)c;
	Get_ClassID cid = *gcid;
	return cid(def);
#else
	DefinitionClass *d = def + 4;
	char *c = (char *)*(unsigned int *)d;
	c += 0x28;
	Get_ClassID *gcid = (Get_ClassID *)c;
	Get_ClassID cid = *gcid;
	return cid(def);
#endif
#endif
}
const char *Get_Definition_Name(DefinitionClass *def)
{
	char *c = (char *)def;
	c += 0x0C;
	return (const char *)*(unsigned int *)c;
}
unsigned int Get_Definition_ID(DefinitionClass *def)
{
	char *c = (char *)def;
	c += 0x10;
	return (unsigned int)*(unsigned int *)c;
}
void Soldier_Re_Init(GameObject *obj,DefinitionClass *def)
{
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov eax,def
		mov ebx,SoldierReInit
		push eax
		call ebx
	}
#else
	SoldierReInit(obj,def);
#endif
}
DefinitionClass *Find_Named_Definition(const char *name)
{
	return FindNamedDef(name,1);
}
void Post_Re_Init(GameObject *obj)
{
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,Post_ReInit
		call ebx
	}
#else
	Post_ReInit(obj);
#endif
}
bool Change_Character(GameObject *obj,const char *Preset_Name)
{
	DefinitionClass *def = Find_Named_Definition(Preset_Name);
	if (def == 0)
	{
		return false;
	}
	if (Get_Class_ID(def) != 0x3001)
	{
		return false;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	Soldier_Re_Init(o,def);
	Post_Re_Init(o);
	return true;
}
const char *WideCharToChar(const wchar_t* wcs)
{
	int length = wcslen(wcs);
	char *text = (char *)malloc(length+1);
	wcstombs(text,wcs,length+1);
	return text;
}
const char *Get_Player_Name(GameObject *obj)
{
	GameObject *o = As_SoldierGameObj(obj);
	char *c = (char *)o;
	if (o == 0)
	{
		return 0;
	}
	c += 0x960;
	char *x = (char *)*(unsigned int *)c;
	if (x == 0)
	{
		return 0;
	}
#ifdef RH8
	x += 0x754;
#else
	x += 0x758;
#endif
	return WideCharToChar((const wchar_t *)*(unsigned int *)x);
}
const char *Get_Player_Name_By_ID(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (x == 0)
	{
		return 0;
	}
#ifdef RH8
	x += 0x754;
#else
	x += 0x758;
#endif
	return WideCharToChar((const wchar_t *)*(unsigned int *)x);
}
void Change_Team_By_ID(int ID,int Team)
{
	unsigned char *x = FindPlayer(ID);
	if (x == 0)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ebx, SetPlayerType
		mov ecx, x
		push Team
		call ebx
	}
#else
	SetPlayerType(x,Team);
#endif
	GameObject *obj = Get_GameObj(ID);
	Commands->Destroy_Object(obj);
}
void Change_Team(GameObject *obj,int Team)
{
	GameObject *o = As_SoldierGameObj(obj);
	if (o == 0)
	{
		return;
	}
	char *c = (char *)o;
	c += 0x960;
	unsigned char *x = (unsigned char *)*(unsigned int *)c;
	if (x == 0)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ebx, SetPlayerType
		mov ecx, x
		push Team
		call ebx
	}
#else
	SetPlayerType(x,Team);
#endif
	Commands->Destroy_Object(obj);
}
int Get_Player_Count()
{
	return GetPlayerCount();
}
int Get_Player_ID(GameObject *obj)
{
	GameObject *o = As_SoldierGameObj(obj);
	if (o == 0)
	{
		return 0;
	}
	char *c = (char *)o;
	c += 0x960;
	char *x = (char *)*(unsigned int *)c;
	if (x == 0)
	{
		return 0;
	}
	x += 0x75C;
	return (int)*(unsigned int *)x;
}
GameObject *Get_GameObj(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (x){
#ifdef WIN32
		unsigned char *playerdata = (unsigned char *)x + 0x14;
#else
#ifdef RH8
		unsigned char *playerdata = (unsigned char *)x + 0x14;
#else
		unsigned char *playerdata = (unsigned char *)x + 0x10;
#endif
#endif
		unsigned char *y = (unsigned char*)*((unsigned char **)playerdata);
		if (y == 0)
		{
			return NULL;
		}
		y += 4;
		GameObject *z = (GameObject *)*(GameObject **)y;
		return z;
	}
	else 
	{
		return NULL;
	}
}
GameObject *Find_Building_By_Class_ID(int Team, int Class_ID)
{
	if (BuildingGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			DefinitionClass *d = Get_Definition(x->obj);
			if (Get_Class_ID(d) == Class_ID)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->next;
	}
	return 0;
}
GameObject *Find_Building_By_Team(int Team)
{
	if (BuildingGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				return o;
			}
		}
		x = x->next;
	}
	return 0;
}
GameObject *Find_Building_By_Name(int Team, const char *Preset_Name)
{
	if (BuildingGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			DefinitionClass *d = Get_Definition(x->obj);
			if (stricmp(Get_Definition_Name(d),Preset_Name) == 0)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->next;
	}
	return 0;
}
void Kill_All_Buildings_By_Team(int Team)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}
	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				Commands->Apply_Damage(o,10000,"Explosive",0);
			}
		}
		x = x->next;
	}
}
void Damage_All_Buildings_By_Team(int Team,float Damage,const char *Warhead,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}
	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			if ((Get_Object_Type(o) == Team) || (Team == 2))
			{
				Commands->Apply_Damage(o,Damage,Warhead,Damager);
			}
		}
		x = x->next;
	}
}
void Repair_All_Buildings_By_Team(int Team,int ConstructionYardID,float Health)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}
	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			if ((Get_Object_Type(o) == Team) && (Commands->Get_ID(o) != ConstructionYardID))
			{
				float amount = Commands->Get_Health(o);
				if (amount>0)
				{
					Commands->Set_Health(o,(amount+Health));
				}
			}
		}
		x = x->next;
	}
}
void Repair_All_Static_Vehicles_By_Team(int Team,int Message)
{
	if (SmartGameObjList->head == 0)
	{
		return;
	}
	GameObjListNode *x = SmartGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_VehicleGameObj(x->obj);
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				if (Is_DecorationPhys(o))
				{
					Commands->Send_Custom_Event(o,o,Message,0,0);
				}
			}
		}
		x = x->next;
	}
	return;
}
GameObject *Find_Smart_Object_By_Team(int Team)
{
	if (SmartGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = SmartGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_SmartGameObj(x->obj);
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				return o;
			}
		}
		x = x->next;
	}
	return 0;
}
GameObject *Find_Object_By_Team(int Team)
{
	if (BaseGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0)
	{
		GameObject *o = x->obj;
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				return o;
			}
		}
		x = x->next;
	}
	return 0;
}
GameObject *Find_Non_Player_Object_By_Team(int Team)
{
	if (SmartGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = SmartGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_SmartGameObj(x->obj);
		if (o != 0)
		{
			if ((Get_Object_Type(o) == Team) && (!Commands->Is_A_Star(o)))
			{
				return o;
			}
		}
		x = x->next;
	}
	return 0;
}
GameObject *Find_Object_By_Preset(int Team,const char *Preset_Name)
{
	if (BaseGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0)
	{
		GameObject *o = x->obj;
		if (o != 0)
		{
			DefinitionClass *d = Get_Definition(x->obj);
			if (stricmp(Get_Definition_Name(d),Preset_Name))
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->next;
	}
	return 0;
}
GameObject *Find_Power_Plant(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD003);
}
GameObject *Find_Refinery(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD002);
}
GameObject *Find_Repair_Bay(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD009);
}
GameObject *Find_Soldier_Factory(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD004);
}
GameObject *Find_Airstrip(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD006);
}
GameObject *Find_War_Factory(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD007);
}
GameObject *Find_Vehicle_Factory(int Team)
{
	GameObject *o = Find_Airstrip(Team);
	if (o != 0)
	{
		return o;
	}
	return Find_War_Factory(Team);
}
GameObject *Find_Com_Center(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD008);
}
bool Is_Building(GameObject *obj)
{
	if (As_BuildingGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Soldier(GameObject *obj)
{
	if (As_SoldierGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Vehicle(GameObject *obj)
{
	if (As_VehicleGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Cinematic(GameObject *obj)
{
	if (As_CinematicGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_ScriptZone(GameObject *obj)
{
	if (As_ScriptZoneGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_TrackedVehicle(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900C)
	{
		return false;
	}
	return true;
}
bool Is_VTOLVehicle(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900D)
	{
		return false;
	}
	return true;
}
bool Is_WheeledVehicle(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9006)
	{
		return false;
	}
	return true;
}
bool Is_Motorcycle(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9002)
	{
		return false;
	}
	return true;
}
bool Is_Door(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9080)
	{
		return false;
	}
	return true;
}
bool Is_Elevator(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9081)
	{
		return false;
	}
	return true;
}
bool Is_DamageableStaticPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9082)
	{
		return false;
	}
	return true;
}
bool Is_AccessablePhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9010)
	{
		return false;
	}
	return true;
}
bool Is_DecorationPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9000)
	{
		return false;
	}
	return true;
}
bool Is_HumanPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9001)
	{
		return false;
	}
	return true;
}
bool Is_MotorVehicle(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9003)
	{
		return false;
	}
	return true;
}
bool Is_Phys3(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9004)
	{
		return false;
	}
	return true;
}
bool Is_RigidBody(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9005)
	{
		return false;
	}
	return true;
}
bool Is_ShakeableStatricPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900F)
	{
		return false;
	}
	return true;
}
bool Is_StaticAnimPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9008)
	{
		return false;
	}
	return true;
}
bool Is_StaticPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9007)
	{
		return false;
	}
	return true;
}
bool Is_TimedDecorationPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900A)
	{
		return false;
	}
	return true;
}
bool Is_VehiclePhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900B)
	{
		return false;
	}
	return true;
}
bool Is_DynamicAnimPhys(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900E)
	{
		return false;
	}
	return true;
}
bool Is_BuildingAggregate(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9083)
	{
		return false;
	}
	return true;
}
bool Is_Projectile(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9009)
	{
		return false;
	}
	return true;
}
void Set_Max_Health(GameObject *obj,float health)
{
	GameObject *o = As_DamageableGameObj(obj);
	if (o == 0)
	{
		return;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	_asm {
		mov ecx,def
		mov eax,health
		mov ebx,SetMaxHealth
		push eax
		call ebx
	}
#else
	SetMaxHealth(def,health);
#endif
	Commands->Set_Health(obj,health);
}
void Set_Max_Shield_Strength(GameObject *obj,float shieldstrength)
{
	GameObject *o = As_DamageableGameObj(obj);
	if (o == 0)
	{
		return;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	_asm {
		mov ecx,def
		mov eax,shieldstrength
		mov ebx,SetMaxShieldStrength
		push eax
		call ebx
	}
#else
	SetMaxShieldStrength(def,shieldstrength);
#endif
	Commands->Set_Shield_Strength(obj,shieldstrength);
}
GameObject *Find_First_Player(int Team)
{
	if (BaseGameObjList->head == 0)
	{
		return 0;
	}
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0)
	{
		GameObject *o = x->obj;
		if (o != 0)
		{
			if (Commands->Is_A_Star(o))
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->next;
	}
	return 0;
}
//doesnt work for CinematicGameObjs
float Get_Animation_Frame(GameObject *obj)
{
	GameObject *o = As_PhysicalGameObj(obj);
	if (o == 0)
	{
		return 0;
	}
	unsigned char *c = o+0x778;
	unsigned char *x = *(unsigned char **)c;
	float a = (float)*(float *)(x+0x14);
	return a;
}
void Grant_Refill(GameObject *obj)
{
	GameObject *o = As_SoldierGameObj(obj);
	if (o != 0)
	{
		Grant_Supplies(obj);
	}
}
void Grant_Powerup(GameObject *obj,const char *Preset_Name)
{
	GameObject *o = As_SmartGameObj(obj);
	if (o != 0)
	{
		DefinitionClass *def = Find_Named_Definition(Preset_Name);
#ifdef WIN32
		_asm {
			mov ecx,def
			mov eax,o
			mov ebx,Powerup_Grant
			push 1
			push 0
			push eax
			call ebx
		}
#else
		Powerup_Grant(def,o,0,true);
#endif
	}
}
GameObject *Get_Vehicle(GameObject *obj)
{
	GameObject *o = As_SoldierGameObj(obj);
	if (o != 0)
	{
		char *c = (char *)o;
		c += 0x98C;
		unsigned long *l = (unsigned long *)c;
		GameObject *vehicle = (GameObject *)*l;
		if (vehicle != 0)
		{
			GameObject *v = As_VehicleGameObj(vehicle);
			return v;
		}
		return 0;
	}
	return 0;
}
const char *Get_Shield_Type(GameObject *obj)
{
	GameObject *o = As_DamageableGameObj(obj);
	if (o == 0)
	{
		return "";
	}
	char *def = (char *)(o+0x72C);
	char *def2 = (char *)def;
#ifdef WIN32
	def2+=0x18;
#else
#ifdef RH8
	def2+=0x18;
#else
	def2+=0x14;
#endif
#endif
	unsigned int *def3 = (unsigned int *)def2;
	return Get_Armor_Name(*def3);
}
const char *Get_Skin(GameObject *obj)
{
	GameObject *o = As_DamageableGameObj(obj);
	if (o == 0)
	{
		return "";
	}
	char *def = (char *)(o+0x72C);
	char *def2 = (char *)def;
#ifdef WIN32
	def2+=0xC;
#else
#ifdef RH8
	def2+=0xC;
#else
	def2+=0x8;
#endif
#endif
	unsigned int *def3 = (unsigned int *)def2;
	return Get_Armor_Name(*def3);
}
void Set_Skin(GameObject *obj,const char *Skintype)
{
	GameObject *o = As_DamageableGameObj(obj);
	if (o == 0)
	{
		return;
	}
	char *def = (char *)(o+0x72C);
	char *def2 = (char *)def;
	unsigned int skin = Get_Armor_Type(Skintype);
#ifdef WIN32
	def2+=0xC;
#else
#ifdef RH8
	def2+=0xC;
#else
	def2+=0x8;
#endif
#endif
	unsigned int *sk = (unsigned int *)def2;
	*sk = skin;
#ifdef WIN32
	_asm {
		mov ecx,def
		mov ebx,Mark_Owner_Dirty
		call ebx
	}
#else
	Mark_Owner_Dirty(def);
#endif
}
void Create_Vehicle(const char *Preset_Name, float Delay, GameObject *Owner, int Team)
{
	GameObject *o = 0;
	if (Owner != 0)
	{
		o = As_SoldierGameObj(Owner);
	}
	DefinitionClass *def = Find_Named_Definition(Preset_Name);
	if (def != 0)
	{
		if (Get_Vehicle(o) == 0)
		{
			GameObject *factory = Find_Vehicle_Factory(Team);
			if (factory != 0)
			{
				bool IsAvail;
#ifdef WIN32
				_asm {
					mov ecx,factory
					mov ebx,Is_Available_For_Purchase
					call ebx
					mov IsAvail, al;
				}
#else
				IsAvail = Is_Available_For_Purchase(factory);
#endif
				if (IsAvail == true)
				{
					unsigned int ID = Get_Definition_ID(def);
#ifdef WIN32
					_asm {
						mov ecx,factory
						mov ebx,Request_Vehicle
						mov eax,o
						push eax
						mov eax,Delay
						push eax
						mov eax,ID
						push eax
						call ebx
					}
#else
					Request_Vehicle(factory,ID,Delay,o);
#endif
				}
			}
		}
	}
}
void Toggle_Fly_Mode(GameObject *obj)
{
	GameObject *o = As_SoldierGameObj(obj);
	if (o != 0)
	{
#ifdef WIN32
		_asm {
			mov ecx,o
			mov ebx,ToggleFly
			call ebx
		}
#else
		ToggleFly(o);
#endif
		Commands->Enable_Collisions(o);
	}
}
void Console_Input(const char *Input)
{
	Parse_Console_Input(Input);
}
void Console_Output(const char *Output)
{
	Output_To_Console(Output);
}
GameObject *As_PowerupGameObj(GameObject *obj)
{
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x88]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x90;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_C4GameObj(GameObject *obj)
{
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x8C]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x94;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_BeaconGameObj(GameObject *obj)
{
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x90]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB8;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x98;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_ArmedGameObj(GameObject *obj)
{
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x94]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xBC;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x9C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_SimpleGameObj(GameObject *obj)
{
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x9C]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xC4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0xA4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_PowerPlantGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x70]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x94;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x78;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_SoldierFactoryGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x74]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x98;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x7C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_VehicleFactoryGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x78]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x9C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x80;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_AirstripGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x7C]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xA0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x84;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_WarFactoryGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x80]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xA4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x88;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_RefineryGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x84]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xA8;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x8C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_ComCenterGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x88]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xAC;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x90;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
GameObject *As_RepairBayGameObj(GameObject *obj)
{
	GameObject *o2 = As_BuildingGameObj(obj);
	if (o2 == 0)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx, o2
		mov ebx, [ecx]
		mov eax, [ebx+0x8C]
		call eax
	}
#else
#ifdef RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x94;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
#endif
}
bool Is_Powerup(GameObject *obj)
{
	if (As_PowerupGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_C4(GameObject *obj)
{
	if (As_C4GameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Beacon(GameObject *obj)
{
	if (As_BeaconGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Armed(GameObject *obj)
{
	if (As_ArmedGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Simple(GameObject *obj)
{
	if (As_SimpleGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_PowerPlant(GameObject *obj)
{
	if (As_PowerPlantGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_SoldierFactory(GameObject *obj)
{
	if (As_SoldierFactoryGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_VehicleFactory(GameObject *obj)
{
	if (As_VehicleFactoryGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Airstrip(GameObject *obj)
{
	if (As_AirstripGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_WarFactory(GameObject *obj)
{
	if (As_WarFactoryGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_Refinery(GameObject *obj)
{
	if (As_RefineryGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_ComCenter(GameObject *obj)
{
	if (As_ComCenterGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
bool Is_RepairBay(GameObject *obj)
{
	if (As_RepairBayGameObj(obj) != 0)
	{
		return true;
	}
	return false;
}
void Damage_All_Objects_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager) 
{
	GameObjListNode *z = BaseGameObjList->head;
	while (z != 0) 
	{
		GameObject *obj = z->obj;
		if (obj != 0) 
		{
			Vector3 ObjPosition = Commands->Get_Position(obj);
			Vector3 TestPosition = Position;
			ObjPosition.Z = 0;
			TestPosition.Z = 0;
			if ((Commands->Get_Distance(ObjPosition,TestPosition) <= Distance) && (Commands->Get_ID(obj) != Commands->Get_ID(Host)))
			{
				Commands->Apply_Damage(obj,Damage,Warhead,Damager);
			}
		}
		z = z->next;
	}
}
void Damage_All_Vehicles_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager)
{
	GameObjListNode *z = BaseGameObjList->head;
	while (z != 0) 
	{
		GameObject *obj = As_VehicleGameObj(z->obj);
		if (obj != 0) 
		{
			Vector3 ObjPosition = Commands->Get_Position(obj);
			Vector3 TestPosition = Position;
			ObjPosition.Z = 0;
			TestPosition.Z = 0;
			if ((Commands->Get_Distance(ObjPosition,TestPosition) <= Distance) && (Commands->Get_ID(obj) != Commands->Get_ID(Host)))
			{
				Commands->Apply_Damage(obj,Damage,Warhead,Damager);
			}
		}
		z = z->next;
	}
}
int Get_Team_Player_Count(int Team)
{
	int Total = 0;
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_SoldierGameObj(x->obj);
		if (o != 0 && Get_Object_Type(o) == Team)
		{
			Total ++;
		}
		x = x->next;
	}
	return Total;
}
const char *Get_Building_Type(GameObject *obj)
{
	if (Is_PowerPlant(obj))
	{
		return "Is_PowerPlant";
	}
	else if (Is_SoldierFactory(obj))
	{
		return "Is_SoldierFactory";
	}
	else if (Is_VehicleFactory(obj))
	{
		if (Is_Airstrip(obj))
		{
			return "Is_Airstrip";
		}
		else if (Is_WarFactory(obj))
		{
			return "Is_WarFactory";
		}
	}
	else if (Is_Refinery(obj))
	{
		return "Is_Refinery";
	}
	else if (Is_ComCenter(obj))
	{
		return "Is_ComCenter";
	}
	else if (Is_RepairBay(obj))
	{
		return "Is_RepairBay";
	}
	else
	{
		return "(null)";
	}
}
const char *Get_Physics(GameObject *obj)
{
	if (Is_Door(obj)) return "Is_Door";
	else if (Is_Elevator(obj)) return "Is_Elevator";
	else if (Is_DamageableStaticPhys(obj)) return "Is_DamageableStaticPhys";
	else if (Is_AccessablePhys(obj)) return "Is_AccessablePhys";
	else if (Is_DecorationPhys(obj)) return "Is_DecorationPhys";
	else if (Is_HumanPhys(obj)) return "Is_HumanPhys";
	else if (Is_MotorVehicle(obj)) return "Is_MotorVehicle";
	else if (Is_Phys3(obj)) return "Is_Phys3";
	else if (Is_RigidBody(obj)) return "Is_RigidBody";
	else if (Is_ShakeableStatricPhys(obj)) return "Is_ShakeableStatricPhys";
	else if (Is_StaticAnimPhys(obj)) return "Is_StaticAnimPhys";
	else if (Is_StaticPhys(obj)) return "Is_StaticPhys";
	else if (Is_TimedDecorationPhys(obj)) return "Is_TimedDecorationPhys";
	else if (Is_VehiclePhys(obj)) return "Is_VehiclePhys";
	else if (Is_DynamicAnimPhys(obj)) return "Is_DynamicAnimPhys";
	else if (Is_BuildingAggregate(obj)) return "Is_BuildingAggregate";
	else if (Is_Projectile(obj)) return "Is_Projectile";
	else return "(null)";
}
void Disarm_Nearest_Beacon(GameObject *Host, int Team, bool Nearest)
{
	Vector3 HostPos = Commands->Get_Position(Host);
	HostPos.Z = 0;
	float NearestDistanceFound = 5000.0f;
	GameObject *ClosestBeacon = Commands->Create_Object("Invisible_Object",HostPos);
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0)
	{
		GameObject *o = x->obj;
		if (o != 0 && Is_Beacon(o))
		{
			if (Team == 2)
			{
				if (Nearest)
				{
					Vector3 BeaconPos = Commands->Get_Position(o);
					BeaconPos.Z = 0;
					if (Commands->Get_Distance(BeaconPos,HostPos) < NearestDistanceFound)
					{
						NearestDistanceFound = Commands->Get_Distance(BeaconPos,HostPos);
						ClosestBeacon = o;
					}
				}
				else
				{
					Commands->Apply_Damage(o,99999,"Death",false);
				}
			}
			else if (Get_Object_Type(o) == Team)
			{
				if (Nearest)
				{
					Vector3 BeaconPos = Commands->Get_Position(o);
					BeaconPos.Z = 0;
					if (Commands->Get_Distance(BeaconPos,HostPos) < NearestDistanceFound)
					{
						NearestDistanceFound = Commands->Get_Distance(BeaconPos,HostPos);
						ClosestBeacon = o;
					}
				}
				else 
				{
					Commands->Apply_Damage(o,99999,"Death",false);
				}
			}
		}
		x = x->next;
	}
	if (Nearest && ClosestBeacon != 0 && Is_Beacon(ClosestBeacon))
	{
		Commands->Apply_Damage(ClosestBeacon,99999,"Death",false);
	}
}
bool Change_Player_Team(GameObject *obj, bool Retain_Score, bool Retain_Money, bool Show_Host_Message)
{
	float Score = Commands->Get_Points(obj);
	float Credits = Commands->Get_Money(obj);
	Commands->Give_Points(obj,(Score * -1),false);
	if (Score < 0)
	{
		Commands->Give_Money(obj,Score,false);
	}
	Commands->Give_Money(obj,(Credits * -1),false);
	if (Commands->Get_Player_Type(obj) == 0)
	{
		Change_Team(obj,1);
	}
	else if (Commands->Get_Player_Type(obj) == 1)
	{
		Change_Team(obj,0);
	}
	if (Retain_Score)
	{
		Commands->Give_Points(obj,Score,false);
		if (Score > 0)
		{
			Commands->Give_Money(obj,(Score * -1),false);
		}
	}
	if (Retain_Money)
	{
		Commands->Give_Money(obj,Credits,false);
	}
	if (As_SoldierGameObj(obj) == 0)
	{
		return false;
	}
	else if (Show_Host_Message)
	{
		char outputmsg[100];
		sprintf(outputmsg,"msg %s switched teams",Get_Player_Name_By_ID(Get_Player_ID(obj)));
		Console_Output(outputmsg);
	}
	return true;
}
void Ranged_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	if(DamageRadius > 0) //Just in case someone was stupid
	{
		GameObjListNode *x = BuildingGameObjList->head;
		while (x != 0)
		{
			GameObject *o = As_BuildingGameObj(x->obj);
			if (o != 0)
			{
				float health = Commands->Get_Health(o);
				if(health > 0) //Is it already dead?
				{
					Vector3 pos1 = Commands->Get_Position(o);
					Vector3 pos2 = Location;

					float Distance = Commands->Get_Distance(pos1,pos2);

					if(Distance <= DamageRadius)
					{
						Commands->Apply_Damage(o,Damage,Warhead,Damager);
					}
				}
			}
			x = x->next;
		}
	}
}
void Ranged_Scale_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	if(DamageRadius > 0) //Just in case someone was stupid
	{
		float Ratio = Damage/DamageRadius; //Get now to avoid repeated division

		GameObjListNode *x = BuildingGameObjList->head;
		while (x != 0)
		{
			GameObject *o = As_BuildingGameObj(x->obj);
			if (o != 0)
			{
				float health = Commands->Get_Health(o);
				if(health > 0) //Is it already dead?
				{
					Vector3 pos1 = Commands->Get_Position(o);
					Vector3 pos2 = Location;

					float Distance = Commands->Get_Distance(pos1,pos2);

					if(Distance <= DamageRadius)
					{
						float scaledamage = (Damage - (Distance * (Ratio)));
						Commands->Apply_Damage(o,scaledamage,Warhead,Damager);
					}
				}
			}
			x = x->next;
		}
	}
}
void Ranged_Percentage_Damage_To_Buildings(float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	if(DamageRadius > 0) //Just in case someone was stupid
	{
		GameObjListNode *x = BuildingGameObjList->head;
		while (x != 0)
		{
			GameObject *o = As_BuildingGameObj(x->obj);
			if (o != 0)
			{
				float health = Commands->Get_Health(o);
				if(health > 0) //Is it already dead?
				{
					Vector3 pos1 = Commands->Get_Position(o);
					Vector3 pos2 = Location;

					float Distance = Commands->Get_Distance(pos1,pos2);

					if(Distance <= DamageRadius)
					{
						float Max_Health = Commands->Get_Max_Health(o);
						float Damage = Max_Health * Percentage; //Calculate based on building's max health
						Commands->Apply_Damage(o,Damage,Warhead,Damager);
					}
				}
			}
			x = x->next;
		}
	}
}
void Ranged_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	if(DamageRadius > 0) //Just in case someone was stupid
	{
		GameObjListNode *x = BuildingGameObjList->head;
		while (x != 0)
		{
			GameObject *o = As_BuildingGameObj(x->obj);
			if (o != 0)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					float health = Commands->Get_Health(o);
					if(health > 0) //Is it already dead?
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;
						float Distance = Commands->Get_Distance(pos1,pos2);
						if(Distance <= DamageRadius)
						{
							Commands->Apply_Damage(o,Damage,Warhead,Damager);
						}
					}
				}
			}
			x = x->next;
		}
	}
}
void Ranged_Scale_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	if(DamageRadius > 0) //Just in case someone was stupid
	{
		float Ratio = Damage/DamageRadius; //Get now to avoid repeated division

		GameObjListNode *x = BuildingGameObjList->head;
		while (x != 0)
		{
			GameObject *o = As_BuildingGameObj(x->obj);
			if (o != 0)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					float health = Commands->Get_Health(o);
					if(health > 0) //Is it already dead?
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;
						float Distance = Commands->Get_Distance(pos1,pos2);
						if(Distance <= DamageRadius)
						{
							float scaledamage = (Damage - (Distance * (Ratio)));
							Commands->Apply_Damage(o,scaledamage,Warhead,Damager);
						}
					}
				}
			}
			x = x->next;
		}
	}
}
void Ranged_Percentage_Damage_To_Buildings_Team(int Team,float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	if(DamageRadius > 0) //Just in case someone was stupid
	{
		GameObjListNode *x = BuildingGameObjList->head;
		while (x != 0)
		{
			GameObject *o = As_BuildingGameObj(x->obj);
			if (o != 0)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					float health = Commands->Get_Health(o);
					if(health > 0) //Is it already dead?
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;
						float Distance = Commands->Get_Distance(pos1,pos2);
						if(Distance <= DamageRadius)
						{
							float Max_Health = Commands->Get_Max_Health(o);
							float Damage = Max_Health * Percentage; //Calculate based on building's max health
							Commands->Apply_Damage(o,Damage,Warhead,Damager);
						}
					}
				}
			}
			x = x->next;
		}
	}
}
void Send_Custom_To_Team_Buildings(int Team, GameObject *sender,int message,int param,float delay)
{
	if (BuildingGameObjList->head == 0)
	{
		return;
	}

	GameObjListNode *x = BuildingGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_BuildingGameObj(x->obj);
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				int ReceiverID = Commands->Get_ID(o);
				int SenderID = Commands->Get_ID(sender);

				if(SenderID != ReceiverID) //Don't send to self
				{
					Commands->Send_Custom_Event(sender, o, message, param, delay);
				}
			}
		}
		x = x->next;
	}
}
void Send_Custom_To_Team_Preset(int Team, const char *PresetName,GameObject *sender,int message,int param,float delay)
{
	if (BaseGameObjList->head == 0)
	{
		return;
	}

	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0)
	{
		GameObject *o = x->obj;
		if (o != 0)
		{
			if (Get_Object_Type(o) == Team)
			{
				if(strcmp(Commands->Get_Preset_Name(o),PresetName) == 0)
				{
					Commands->Send_Custom_Event(sender, o, message, param, delay);
				}
			}
		}
		x = x->next;
	}
}
void Enable_Team_Radar(int Team,bool Enable)
{
	if (SmartGameObjList->head == 0)
	{
		return;
	}
	GameObjListNode *x = SmartGameObjList->head;
	while (x != 0)
	{
		GameObject *o = As_SmartGameObj(x->obj);
		if (o != 0)
		{
			if ((Get_Object_Type(o) == Team) || (Team == 2))
			{
				Enable_Radar_Player(o,Enable);
			}
		}
		x = x->next;
	}
	return;
}
/*class M00_GrantPowerup_Created : public ScriptImpClass {
	void Created(GameObject * obj);
	void Timer_Expired(GameObject * obj,int number);
};
void M00_GrantPowerup_Created::Timer_Expired(GameObject * obj,int number)
{
	switch (number)
	{
	case 1:
		Commands->Set_Background_Music("ghostb.mp3");
		break;
	case 2:
		Commands->Create_Sound("Obelisk_Warm_Up",Commands->Get_Position(obj),obj);
		break;
	case 3:
		Commands->Create_2D_Sound("CnC_Cloaking");
		break;
	case 4:
		Commands->Create_2D_WAV_Sound("c&c cloaking.wav");
		break;
	case 5:
		Commands->Create_3D_WAV_Sound_At_Bone("obelpowr.wav",obj,"ROOTTRANSFORM");
		break;
	case 6:
		Commands->Create_3D_Sound_At_Bone("Obelisk_Warm_Up",obj,"ROOTTRANSFORM");
		break;
	case 7:
		Commands->Play_Building_Announcement(Find_Airstrip(0),1);
		break;
	}
}
void M00_GrantPowerup_Created::Created(GameObject * obj)
{
	Commands->Start_Timer(obj,this,5.0,1);
	Commands->Start_Timer(obj,this,10.0,2);
	Commands->Start_Timer(obj,this,15.0,3);
	Commands->Start_Timer(obj,this,20.0,4);
	Commands->Start_Timer(obj,this,25.0,5);
	Commands->Start_Timer(obj,this,30.0,6);
	Commands->Start_Timer(obj,this,35.0,7);
	Commands->Give_Powerup(obj,Get_Parameter("WeaponDef"),false);
}
ScriptRegistrant<M00_GrantPowerup_Created> M00_GrantPowerup_Created_Registrant("M00_GrantPowerup_Created","WeaponDef:string");*/


GameObject *Find_Base_Defense(int Team) {
	if (Team == 0) return Find_Building_By_Name(0,"mp_Nod_Obelisk");
	return Find_Building_By_Name(1,"mp_GDI_Advanced_Guard_Tower");
}
int Get_Beacon_Count(int Team) {
	int Total = 0;
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0) {
		GameObject *o = x->obj;
		if (o != 0 && Is_Beacon(o)) {
			if (Team == 2) Total++;
			else if (Get_Object_Type(o) == Team) Total++;
		}
		x = x->next;
	}
	return Total;	
}
int Get_C4_Count(int Team) {
	int Total = 0;
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0) {
		GameObject *o = x->obj;
		if (o != 0 && Is_C4(o)) {
			if (Team == 2) Total++;
			else if (Get_Object_Type(o) == Team) Total++;
		}
		x = x->next;
	}
	return Total;	
}
GameObject *Find_Beacon(int Number, int Team) { 
	if (Number < 0) Number = 0;
	if (Number == 0) return 0;
	int Total = 0;
	GameObject *ReturnObj = 0;
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0) {
		GameObject *o = x->obj;
		if (o != 0 && Is_Beacon(o)) {
			if (Team == 2) Total++;
			else if (Get_Object_Type(o) == Team) Total++;
			if (Total == Number) ReturnObj = o; 
		}
		x = x->next;
	}
	if (ReturnObj == 0) return 0;
	return ReturnObj;
}
GameObject *Get_Beacon_Object(GameObject *obj) {
	Vector3 ObjPosition = Commands->Get_Position(obj);
	GameObject *BeaconObj = 0;
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0) {
		GameObject *o = x->obj;
		if (o != 0 && Is_Beacon(o) && (Commands->Get_Position(o).X == ObjPosition.X && Commands->Get_Position(o).Y == ObjPosition.Y && Commands->Get_Position(o).Z == ObjPosition.Z)) BeaconObj = o;
		x = x->next;
	}
	return BeaconObj;
}

GameObject *Get_Beacon_Planter(GameObject *obj) {
	GameObject *Planter = 0;
	GameObjListNode *x = BaseGameObjList->head;
	while (x != 0) {
		GameObject *o = x->obj;
		if (o != 0 && As_SoldierGameObj(o)) {
			if (Commands->Get_Position(o).X == Commands->Get_Position(obj).X && Commands->Get_Position(o).Y == Commands->Get_Position(obj).Y && Commands->Get_Position(o).Z == Commands->Get_Position(obj).Z) {
				if (Commands->Get_ID(o) != Commands->Get_ID(obj)) Planter = o;
			}
		}
		x = x->next;
	}
	return Planter;
}

GameObject *Get_Vehicle_Return(GameObject *obj)
{
	GameObject *o = As_SoldierGameObj(obj);
	if (o != 0)
	{
		char *c = (char *)o;
		c += 0x98C;
		unsigned long *l = (unsigned long *)c;
		GameObject *vehicle = (GameObject *)*l;
		if (vehicle != 0)
		{
			GameObject *v = As_VehicleGameObj(vehicle);
			return v;
		}
		return obj;
	}
	return obj;
}

void Damage_Objects_Half() {
	GameObjListNode *z = BaseGameObjList->head;
	while (z != 0) {
		GameObject *obj = z->obj;
		if (obj != 0) {
			if (As_SoldierGameObj(obj) || Is_Vehicle(obj)) {
				float Health = Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj);
				Commands->Apply_Damage(obj,(Health / 2),"None",0);
			}
		} 
		z = z->next;
	} 
}

void Kill_Stealth() {
	GameObjListNode *z = BaseGameObjList->head;
	while (z != 0) {
		GameObject *obj = z->obj;
		if (obj != 0) {
			if (strcmp(Commands->Get_Preset_Name(Get_Vehicle_Return(obj)),"CnC_Nod_FlameThrower_2SF") == 0) {
				Commands->Apply_Damage(obj,99999,"None",0);
			}
			else if (strcmp(Commands->Get_Preset_Name(Get_Vehicle_Return(obj)),"CnC_Nod_Stealth_Tank") == 0) {
				float Health = Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj);
				Commands->Apply_Damage(obj,(Health / 2),"None",0);
			}
		} 
		z = z->next;
	} 
}

void Setup_Show_Stealth() {
	GameObjListNode *z = BaseGameObjList->head;
	while (z != 0) {
		GameObject *obj = z->obj;
		if (obj != 0) {
			if (strcmp(Commands->Get_Preset_Name(Get_Vehicle_Return(obj)),"CnC_Nod_FlameThrower_2SF") == 0) {
				Commands->Attach_Script(obj,"KAK_Show_Stealth","0");
			}
			else if (strcmp(Commands->Get_Preset_Name(Get_Vehicle_Return(obj)),"CnC_Nod_Stealth_Tank") == 0) {
				Commands->Attach_Script(Get_Vehicle(obj),"KAK_Show_Stealth","1");
			}
		} 
		z = z->next;
	} 
}